<?php

namespace Beedask\Models;

use Illuminate\Database\Eloquent\Model;

class User extends Model 
{

    protected $table = 'users';
    public $timestamps = true;
    protected $fillable = array('username', 'ranking', 'scores', 'questions_sent', 'background_path');
    protected $visible = array('username', 'ranking', 'scores', 'questions_sent', 'background_path');

    public function questions()
    {
        return $this->hasMany('Question', 'user_id');
    }

    public function member()
    {
        return $this->hasOne('Member', 'user_id');
    }

    public function votes()
    {
        return $this->hasMany('Vote', 'user_id');
    }

    public function scores()
    {
        return $this->hasMany('Score', 'user_id');
    }

    public function favorites()
    {
        return $this->hasMany('Favorite', 'user_id');
    }

    public function pool()
    {
        return $this->hasMany('Pool', 'user_id');
    }

    public function comments()
    {
        return $this->hasMany('Comment', 'user_id');
    }

}